﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
if (typeof (question) === "undefined") {
    var question = {};
}

question.mid4014 = {
    //general options and settings
    opts: {},

    //format responses
    formatResponses: function () {
        var _me = this;
        $('input[type="text"]').css({ width: '500px' });
    },

    // bind max responses check
    bindMaxResponsesCheck: function () {
        var _me = this;
        $('input[type="checkbox"]', $('div[id$="TID2_QID5"]')).bind({
            click: function (e) {
                _me.maxResponsesCheck(this);
            }
        });
    },

    // check for the maximum number of answers
    maxResponsesCheck: function (ele) {
        var _grp = $('input[type="checkbox"][name="' + $(ele).attr('name') + '"]'),
            _checked = $(_grp).filter(function () {
                return this.checked;
            });

        if (_checked.length < 3) {
            $(_grp).attr('disabled', false);
            return true;
        }
        else if (_checked.length == 3) {
            $(_grp).not(':checked').attr('disabled', true);
            return false;
        }
        else if (_checked.length > 3) {
            ele.checked = false;
            return false;
        }
    },

    //initializing functions
    init: function (callback) {
        var _me = this;

        //wait for DOM readiness
        $(document).ready(function () {
            Ext.onReady(function () {
                setTimeout(function () {
                    //call functions here
                    _me.formatResponses();
                    _me.bindMaxResponsesCheck();

                    //Successful
                    if (callback) {
                        if (typeof (callback.success) == "function") {
                            callback.success();
                        }
                    }
                }, 1);
            });
        });
    }
};